/*
   XBlast Robot File

   (C) by Mark Weyer
*/

#include "humanoid_frames.inc"

Erase_humanoid_input_constants()

#declare leg_length = 1.9;
#declare leg_half_length = 1;
#declare default_rad = 0.2;
#declare back_length = 1.4;
#declare arm_length = 1.7;
#declare arm_half_length = 0.9;

#declare killed_leg_ang = 75;
#declare killed_back_ang = 10;
#declare killed_nod_ang = 45;
#declare losing_back_ang = 10;
#declare losing_max_nod_ang = 30;
#declare winning_jump_height = 0.6;
#declare walking_back_ang = 10;
#declare walking_arm_ang = 75;

#declare left_eye_pos = vrotate(<0,0.5,-0.3>,-30*y);
#declare left_eye_normal = vrotate(-z,-30*y);

Define_humanoid_output_constants()

#macro stick(l,tr,c)
  cylinder {
    -l*y 0 0.15
    pigment {rgb <c.x,c.y,c.z>}
    transform tr
  }
#end

#macro stickk(p1,p2,c)
  cylinder {
    p1 p2 0.15
    pigment {rgb <c.x,c.y,c.z>}
  }
#end

#macro round(p,c)
  sphere {
    p  default_rad
    pigment {rgb <c.x,c.y,c.z>}
  }
#end

union {
  stick(lower_leg_length,left_lower_leg_trans,armsLegsColor)
  stick(lower_leg_length,right_lower_leg_trans,armsLegsColor)
  stick(upper_leg_length,left_upper_leg_trans,armsLegsColor)
  stick(upper_leg_length,right_upper_leg_trans,armsLegsColor)
  stick(back_length,back_trans,bodyColor)
  stick(-0.5,head_trans,helmetColor)
  stick(upper_arm_length,left_upper_arm_trans,armsLegsColor)
  stick(lower_arm_length,left_lower_arm_trans,armsLegsColor)
  stick(upper_arm_length,right_upper_arm_trans,armsLegsColor)
  stick(lower_arm_length,right_lower_arm_trans,armsLegsColor)
  stickk(left_hip_pos,hip_pos,bodyColor)
  stickk(right_hip_pos,hip_pos,bodyColor)
  stickk(left_shoulder_pos,neck_pos,bodyColor)
  stickk(right_shoulder_pos,neck_pos,bodyColor)
  round(left_ankle_pos,handsFeetColor)
  round(right_ankle_pos,handsFeetColor)
  round(left_knee_pos,handsFeetColor)
  round(right_knee_pos,handsFeetColor)
  round(left_hip_pos,handsFeetColor)
  round(right_hip_pos,handsFeetColor)
  round(hip_pos,backpackColor)
  round(neck_pos,backpackColor)
  round(left_shoulder_pos,handsFeetColor)
  round(right_shoulder_pos,handsFeetColor)
  round(left_elbow_pos,handsFeetColor)
  round(right_elbow_pos,handsFeetColor)
  round(left_wrist_pos,handsFeetColor)
  round(right_wrist_pos,handsFeetColor)
  sphere {
    0.5*y  0.3
    pigment {rgb faceColor}
    transform head_trans
  }

  rotate playerAngle*y
  translate playerLocation
  translate -2*z
}

